/* ======================================================
   | 2004 FHTE | Dipl.Ing.(FH) Gnter Dilin
   ======================================================
   | e-mail: guenter@disslin.de
   | Informatik 1
   | --------------
   | OrginalName : Sphaero.cpp
   | OrginalDatum: 2004-10-26
   | ----------------------------
   | Revison: in VERSION definiert
   =======================================================
   | Beschreibung:
   | Beispielprogramm zur C Programmierung
   | Mathematische Grundfunktionen und Variablen
   | und Einfhrung in die Datentypen
   | Beispiel: 
   | Berechnen eines spezifischen Kugelgewichts
   | Erstes Beispiel zur Eingabe ...
   | formatierte Ausgaben
   | IF ...
   | -----
   | Mathem. Grundlagen (nicht physikalisch exakt !):
   | Kugelvolumen      V =(4/3)* pi * r^3
   | Kugeloberflche   A = 4 * pi * r^2
   | Gewicht           G = rho * V
   | -----------------------------------
   | Beschichtung: 
   | Volumen der Beschichtung sei A * Schichtdicke
   =======================================================
*/

#include         <stdio.h> 		      /* Standard IO Bibliothek             */
#include         <math.h>             /* wichtig wenn pow() verwendet wird  */
#define PI            3.14159         /* Pi definieren 5 Stellen nach Komma */
#define VERSION       3.12            /* Versionsnummer                     */
#define SCHICHTD      2.00            /* Schichtdicke [mm]                  */
#define RHO_BESCHICHT 7.853           /* spezif. Gewicht der Beschichtung   */
#define TOLERANZ      0.01            /* Toleranzband in %                  */


int main (void)
{
 /* ---- Variablen ----*/
 
 int    Zaehl;
 int  a,b,c,d;                         /* Variablen des Typs Integer   */
 int    Summe;
 

 float Fl_Summe;                       /* Variablen des Typs Float     */
 float Fl_Diam;                        /* float = Gleitkommazahl       */
 float Fl_Rad, Fl_Volume;             
 float Fl_a,Fl_b,Fl_c,Fl_d;           
 float Fl_Rho;                         /* spezifisches Gewicht Kugel   */                    
 float Fl_Kugelkonst,Fl_Radius_exp3;   
 float Fl_A_Kugel;
 float Fl_V_Beschichtung;
 float Fl_G_Beschichtung;
 float Fl_G_Gesamt,Fl_Dia_dm;
 float Fl_QM_Gut_Oben, Fl_QM_Gut_Unten; /* Toleranzband */
 float Fl_G_Waage;
                                                                 



 /* ------------------ Berechnungen ------------------------ */


    printf("                                                \n");
	printf("     --------------------------------           \n");
    printf("       ** Sphaerofix **                          \n");
	printf("     --------------------------------           \n");
    printf("     Version %.3f                               \n",VERSION);
    printf("                                                \n");
    printf(" Eingaben ohne Einheiten !                      \n");
    printf(" zu 1): Durchmesser in [mm] eingeben (#.###)    \n");
    printf(" zu 2): Rho in [kg/dm^3] eingeben    (#.###)    \n");   
    printf("   Eingaben mit der Enter-Taste                 \n");
    printf("   bestaetigen                                  \n");
    printf("                                                \n");
    printf(" 1)    Kugel-Durchmesser eingeben: ");	
    scanf("%f",&Fl_a);
    printf("                                                \n");
    printf(" 2) Spezifisches Gewicht eingeben: ");
    scanf("%f",&Fl_Rho);
    printf("                                                \n");
    printf("                                                \n");


    Fl_c=(Fl_a/2.0);        /* Durchmesser auf Radius ... */

    Fl_Rad=(Fl_c/100.0);    /* mm auf dm                  */

    Fl_Kugelkonst=(4.0/3.0) * PI;        /* Achtung TYP ! */

	Fl_Radius_exp3 =(Fl_Rad*Fl_Rad*Fl_Rad); /* 'einfache' Lsung */
    // Fl_Radius_exp3 =pow(Fl_Rad,3);       /*  advanced :-)     */
  
	Fl_Volume  = Fl_Kugelkonst * Fl_Radius_exp3;


    printf("  \n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
    printf("                                                \n");
	printf("     --------------------------------           \n");
    printf("       ** Sphaerofix **                          \n");
	printf("     --------------------------------           \n");
    printf("     Version %.3f                               \n",VERSION);
    printf("                                                \n");

	printf(" Eine Kugel mit Radius %9.3f [mm]               \n",Fl_c);
	printf(" Hat ein Volumen von   %9.3f [dm^3]             \n",Fl_Volume);
    printf("                                                \n");	

    Fl_Summe=Fl_Rho*Fl_Volume; /* Gewicht der Kugel */
    
    printf(" Daraus folgt bei einem                         \n");
    printf(" spezifischen Gewicht   :   %8.3f [kg/dm^3]     \n",Fl_Rho);
    printf(" ein Gesamtgewicht Kugel:   %8.3f [kg]          \n",Fl_Summe);
    printf("==========================================      \n");
    
    /* ========== Erweiterungen Version 3 ================= */
    
    Fl_A_Kugel=4.0*PI*(Fl_Rad*Fl_Rad); /* Klammer nur zur bersichlichkeit ! */
    Fl_Dia_dm =(SCHICHTD/100.0);       /* mm auf dm                  */
    Fl_V_Beschichtung=Fl_Dia_dm*Fl_A_Kugel;
    
    Fl_G_Beschichtung=Fl_V_Beschichtung*RHO_BESCHICHT;

    printf("  Gewicht der Beschichtung: %8.3f [kg] \n",Fl_G_Beschichtung);
    
    Fl_G_Gesamt=Fl_Summe+Fl_G_Beschichtung;
    printf(" Gesamtgewicht beschichtet: %8.3f [kg] \n",Fl_G_Gesamt);

    /* QM */
    
    Fl_QM_Gut_Oben  = Fl_G_Gesamt*(1.00+TOLERANZ);
    Fl_QM_Gut_Unten = Fl_G_Gesamt*(1.00-TOLERANZ);
    
    printf(" Daraus folgt bei einer Toleranz von %6.3f %%     \n",TOLERANZ);
    printf(" Obere Grenze  %8.3f      \n",Fl_QM_Gut_Oben);
    printf(" Untere Grenze %8.3f      \n",Fl_QM_Gut_Unten);    
    printf("==========================================      \n");
    printf(" Geben Sie nun das abgelesene Gewicht (Waage) ein:\n");
    printf(" in [kg] eingeben (#.###):");
    scanf("%f",&Fl_G_Waage);
    printf("                                                \n");
       
    if (Fl_G_Waage>Fl_QM_Gut_Oben)
    {
     printf("\n Obere Grenze verletzt: SCHLECHT ");
    } 
    else if (Fl_G_Waage<Fl_QM_Gut_Unten)
    {
     printf("\n Untere Grenze verletzt: SCHLECHT ");
    }
    else
    {
     printf("\n        **** G U T ****       ");
    }

    printf("                                                \n");

return 0;

}

